/** !------------------------------------------------------------------------->
*
*  @file Rte_generated.h
*
*  @creationDate 22 November 2024 11:42:31
*
*  @brief Generated Rte configuration header file.
*
*  @author
*
*  @description
*
*  @copyright
*    Copyright 2024, dSPACE GmbH. All rights reserved.
*
*  @version
*
*   <hr><br>
*!-------------------------------------------------------------------------->*/

/* File ID: bde350a7-151a-44bd-8cff-6b040b30f93f */
#pragma once

#include "../Config.h"
#include "../../BusConfiguration.h"
#include "../Com/Com_generated.h"
#include <Std_Types.h>

/* Signal ID, uint16 does not match with TLSR callback. */
typedef Com_SignalIdType Rte_SignalIdType;

#define RTE_NO_SUCH_SIGNAL 0x75

/*------------------------------------------------------------------------------------------------*\
  GENERATED RTE SIGNAL IDs
  RTE Signal Ids are identical to COM SignalIds for performance reasons
\*------------------------------------------------------------------------------------------------*/

/* RTE Signal definitions for the RTE module. */
#define Rte_X_Inst_1_cmd_battery_pump_11187_10693_11337 Com_X_Inst_1_cmd_battery_pump_11187_10693_11337
#define Rte_X_Inst_2_cmd_chiller_bypass_11186_10693_11337 Com_X_Inst_2_cmd_chiller_bypass_11186_10693_11337
#define Rte_X_Inst_3_cmd_comp_11185_10693_11337 Com_X_Inst_3_cmd_comp_11185_10693_11337
#define Rte_X_Inst_4_cmd_fan_11184_10693_11337 Com_X_Inst_4_cmd_fan_11184_10693_11337
#define Rte_X_Inst_5_cmd_heater_11183_10693_11337 Com_X_Inst_5_cmd_heater_11183_10693_11337
#define Rte_X_Inst_6_cmd_motor_pump_11182_10693_11337 Com_X_Inst_6_cmd_motor_pump_11182_10693_11337
#define Rte_X_Inst_7_cmd_parallel_serial_11181_10693_11337 Com_X_Inst_7_cmd_parallel_serial_11181_10693_11337
#define Rte_X_Inst_8_cmd_rad_bypass_11180_10693_11337 Com_X_Inst_8_cmd_rad_bypass_11180_10693_11337
#define Rte_X_Inst_11_I_traction_11177_10693_11337 Com_X_Inst_11_I_traction_11177_10693_11337
#define Rte_X_Inst_15_Q_charger_11173_10693_11337 Com_X_Inst_15_Q_charger_11173_10693_11337
#define Rte_X_Inst_16_Q_dcdc_11172_10693_11337 Com_X_Inst_16_Q_dcdc_11172_10693_11337
#define Rte_X_Inst_17_Q_inverter_11171_10693_11337 Com_X_Inst_17_Q_inverter_11171_10693_11337
#define Rte_X_Inst_18_Q_motor_11170_10693_11337 Com_X_Inst_18_Q_motor_11170_10693_11337
#define Rte_X_Inst_28_v_vehicle_11160_10693_11337 Com_X_Inst_28_v_vehicle_11160_10693_11337
#define Rte_X_Inst_0_AngVel_Compressor_11188_10693_11337 Com_X_Inst_0_AngVel_Compressor_11188_10693_11337
#define Rte_X_Inst_9_EPower_Compressor_11179_10693_11337 Com_X_Inst_9_EPower_Compressor_11179_10693_11337
#define Rte_X_Inst_10_i_battery_11178_10693_11337 Com_X_Inst_10_i_battery_11178_10693_11337
#define Rte_X_Inst_12_p_chiller_11176_10693_11337 Com_X_Inst_12_p_chiller_11176_10693_11337
#define Rte_X_Inst_13_p_cond_11175_10693_11337 Com_X_Inst_13_p_cond_11175_10693_11337
#define Rte_X_Inst_14_PJoule_battery_11174_10693_11337 Com_X_Inst_14_PJoule_battery_11174_10693_11337
#define Rte_X_Inst_19_T_battery1_11169_10693_11337 Com_X_Inst_19_T_battery1_11169_10693_11337
#define Rte_X_Inst_20_T_battery2_11168_10693_11337 Com_X_Inst_20_T_battery2_11168_10693_11337
#define Rte_X_Inst_21_T_battery3_11167_10693_11337 Com_X_Inst_21_T_battery3_11167_10693_11337
#define Rte_X_Inst_22_T_battery4_11166_10693_11337 Com_X_Inst_22_T_battery4_11166_10693_11337
#define Rte_X_Inst_23_T_coolant_battery_in_11165_10693_11337 Com_X_Inst_23_T_coolant_battery_in_11165_10693_11337
#define Rte_X_Inst_24_T_coolant_inverter_out_11164_10693_11337 Com_X_Inst_24_T_coolant_inverter_out_11164_10693_11337
#define Rte_X_Inst_25_T_inverter_11163_10693_11337 Com_X_Inst_25_T_inverter_11163_10693_11337
#define Rte_X_Inst_26_T_motor_11162_10693_11337 Com_X_Inst_26_T_motor_11162_10693_11337
#define Rte_X_Inst_27_Torque_Compressor_11161_10693_11337 Com_X_Inst_27_Torque_Compressor_11161_10693_11337

/* extern declarations of COM signal variables */
extern uint8 Com_TX_Inst_1_cmd_battery_pump_11187_10693_11337_sgn_val;

extern uint8 Com_TX_Inst_2_cmd_chiller_bypass_11186_10693_11337_sgn_val;

extern uint16 Com_TX_Inst_3_cmd_comp_11185_10693_11337_sgn_val;

extern uint8 Com_TX_Inst_4_cmd_fan_11184_10693_11337_sgn_val;

extern uint8 Com_TX_Inst_5_cmd_heater_11183_10693_11337_sgn_val;

extern uint8 Com_TX_Inst_6_cmd_motor_pump_11182_10693_11337_sgn_val;

extern uint8 Com_TX_Inst_7_cmd_parallel_serial_11181_10693_11337_sgn_val;

extern uint8 Com_TX_Inst_8_cmd_rad_bypass_11180_10693_11337_sgn_val;

extern sint16 Com_TX_Inst_11_I_traction_11177_10693_11337_sgn_val;

extern uint16 Com_TX_Inst_15_Q_charger_11173_10693_11337_sgn_val;

extern uint16 Com_TX_Inst_16_Q_dcdc_11172_10693_11337_sgn_val;

extern uint16 Com_TX_Inst_17_Q_inverter_11171_10693_11337_sgn_val;

extern uint16 Com_TX_Inst_18_Q_motor_11170_10693_11337_sgn_val;

extern uint16 Com_TX_Inst_28_v_vehicle_11160_10693_11337_sgn_val;


extern uint16 Com_RX_Inst_0_AngVel_Compressor_11188_10693_11337_sgn_val;

extern uint16 Com_RX_Inst_9_EPower_Compressor_11179_10693_11337_sgn_val;

extern sint16 Com_RX_Inst_10_i_battery_11178_10693_11337_sgn_val;

extern uint8 Com_RX_Inst_12_p_chiller_11176_10693_11337_sgn_val;

extern uint8 Com_RX_Inst_13_p_cond_11175_10693_11337_sgn_val;

extern uint16 Com_RX_Inst_14_PJoule_battery_11174_10693_11337_sgn_val;

extern uint16 Com_RX_Inst_19_T_battery1_11169_10693_11337_sgn_val;

extern uint16 Com_RX_Inst_20_T_battery2_11168_10693_11337_sgn_val;

extern uint16 Com_RX_Inst_21_T_battery3_11167_10693_11337_sgn_val;

extern uint16 Com_RX_Inst_22_T_battery4_11166_10693_11337_sgn_val;

extern uint16 Com_RX_Inst_23_T_coolant_battery_in_11165_10693_11337_sgn_val;

extern uint16 Com_RX_Inst_24_T_coolant_inverter_out_11164_10693_11337_sgn_val;

extern uint16 Com_RX_Inst_25_T_inverter_11163_10693_11337_sgn_val;

extern uint16 Com_RX_Inst_26_T_motor_11162_10693_11337_sgn_val;

extern uint16 Com_RX_Inst_27_Torque_Compressor_11161_10693_11337_sgn_val;



#define SCALE_IDENTICAL(TARGET_TYPE,TARGET,SOURCE_TYPE,SOURCE,ROUND_SUFFIX) double tmp_val = (*((SOURCE_TYPE*) SOURCE)); \
if (ROUND_SUFFIX && tmp_val > 0) *((TARGET_TYPE*) TARGET) = (TARGET_TYPE) (tmp_val + 0.5); else if (ROUND_SUFFIX && tmp_val < 0)  *((TARGET_TYPE*) TARGET) = (TARGET_TYPE) (tmp_val - 0.5); \
else *((TARGET_TYPE*) TARGET) = (TARGET_TYPE) tmp_val;

#define SCALE_LINEAR(TARGET_TYPE,TARGET,SOURCE_TYPE,SOURCE,N0,N1,D0,ROUND_SUFFIX) double tmp_val = (((( *((SOURCE_TYPE*) SOURCE) ) * N1) + N0) / ((double) D0) ); \
if (ROUND_SUFFIX && tmp_val > 0) *((TARGET_TYPE*) TARGET) = (TARGET_TYPE) (tmp_val + 0.5); else if (ROUND_SUFFIX && tmp_val < 0)  *((TARGET_TYPE*) TARGET) = (TARGET_TYPE) (tmp_val - 0.5); \
else *((TARGET_TYPE*) TARGET) = (TARGET_TYPE) tmp_val;

/*------------------------------------------------------------------------------------------------*\
  FUNCTION PROTOTYPES
\*------------------------------------------------------------------------------------------------*/

#ifdef __cplusplus
 extern "C" {
#endif /* __cplusplus */

/**************************************************************************************************\
 *** FUNCTION:
 ***     Rte_SetCodedValue
 ***
 *** DESCRIPTION:
 ***     Calculates a new coded value, if the physical value has changed.
 ***
 *** PARAMETERS:
 ***     Type              Name           Description
 ***     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ***     Rte_SignalIdType  SignalId       RTE Signal ID of signal to be sent.
 ***     boolean           always         Flag which enforces calculation even if the physical signal did not change.
 ***
 *** RETURNS:
 ***     boolean  Flag which inidcates that a calculation was performed and the underlying
 ***              PDU has to be updated.
 \**************************************************************************************************/
 boolean Rte_SetCodedValue(Rte_SignalIdType SignalId, boolean always);

/**************************************************************************************************\
 *** FUNCTION:
 ***     Rte_SetPhysicalValue
 ***
 *** DESCRIPTION:
 ***     Calculates a new physical value, if the coded value has changed.
 ***
 *** PARAMETERS:
 ***     Type              Name           Description
 ***     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ***     Rte_SignalIdType  SignalId       RTE Signal ID of signal to be sent.
 ***     boolean           always         Flag which enforces calculation even if the coded signal did not change.
 ***                                      This behavior is used for initialization during startup
 ***
\**************************************************************************************************/
void Rte_SetPhysicalValue(Rte_SignalIdType SignalId, boolean always);

/**************************************************************************************************\
 *** FUNCTION:
 ***     Rte_WriteSignal
 ***
 *** DESCRIPTION:
 ***     Updates the signal object identified by SignalId with the signal referenced by the
 ***     SignalDataPtr.
 ***
 *** PARAMETERS:
 ***     Type              Name           Description
 ***     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ***     Rte_SignalIdType  SignalId       RTE Signal ID of signal to be sent.
 ***     const void *      SignalDataPtr  Reference to the signal data to store the received data
 ***                                      in.
 ***
 *** RETURNS:
 ***     uint8    The status code of the function call.
\**************************************************************************************************/
uint8 Rte_WriteSignal(
    Rte_SignalIdType SignalId,
    const void * SignalDataPtr);


/**************************************************************************************************\
 *** FUNCTION:
 ***     Rte_ReadSignal
 ***
 *** DESCRIPTION:
 ***     The function copies the content of the associated shadow buffer to the given memory location
 ***     and performs signal conversion.
 ***
 *** PARAMETERS:
 ***     Type              Name           Description
 ***     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ***     Rte_SignalIdType  SignalId       RTE Signal ID of signal to be read.
 ***     void *            SignalDataPtr  Reference to the signal data to store the received data
 ***                                      in.
 ***
 *** RETURNS:
 ***     uint8    The status code of the function call.
\**************************************************************************************************/
uint8 Rte_ReadSignal(
        Rte_SignalIdType SignalId,
        void * SignalDataPtr);





#ifdef __cplusplus
}
#endif /* __cplusplus */


